/*
  PokeMini - Pokmon-Mini Emulator
  Copyright (C) 2009-2012  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include "InstructionInfo.h"

char *DebugCPUInstructions_Opcode[] = {
	".DB",		//  0 (No instruction)
	"NOP",		//  1
	"MOV",		//  2
	"EXPAND",	//  3
	"ADD",		//  4
	"ADC",		//  5
	"SUB",		//  6
	"SBC",		//  7
	"AND",		//  8
	"OR",		//  9
	"CMP",		// 10
	"XOR",		// 11
	"INC",		// 12
	"DEC",		// 13
	"TST",		// 14
	"EX",		// 15
	"PUSH",		// 16
	"POP",		// 17
	"PUSHX",	// 18
	"POPX",		// 19
	"XCHG",		// 20
	"PACK",		// 21
	"UNPACK",	// 22
	"SWAP",		// 23
	"CALLC",	// 24
	"CALLNC",	// 25
	"CALLZ",	// 26
	"CALLNZ",	// 27
	"JC",		// 28
	"JNC",		// 29
	"JZ",		// 30
	"JNZ",		// 31
	"CALL",		// 32
	"JMP",		// 33
	"JDBNZ",	// 34
	"RET",		// 35
	"RETI",		// 36
	"RETSKIP",	// 37
	"CINT",		// 38
	"JINT",		// 39
	"SAL",		// 40
	"SHL",		// 41
	"SAR",		// 42
	"SHR",		// 43
	"ROLC",		// 44
	"ROL",		// 45
	"RORC",		// 46
	"ROR",		// 47
	"NOT",		// 48
	"NEG",		// 49
	"MUL",		// 50
	"DIV",		// 51
	"PUSHA",	// 52
	"PUSHAX",	// 53
	"POPA",		// 54
	"POPAX",	// 55
	"JL",		// 56
	"JLE",		// 57
	"JG",		// 58
	"JGE",		// 59
	"JO",		// 60
	"JNO",		// 61
	"JNS",		// 62
	"JS",		// 63
	"JNX0",		// 64
	"JNX1",		// 65
	"JNX2",		// 66
	"JNX3",		// 67
	"JX0",		// 68
	"JX1",		// 69
	"JX2",		// 70
	"JX3",		// 71
	"CALLL",	// 72
	"CALLLE",	// 73
	"CALLG",	// 74
	"CALLGE",	// 75
	"CALLO",	// 76
	"CALLNO",	// 77
	"CALLNS",	// 78
	"CALLS",	// 79
	"CALLNX0",	// 80
	"CALLNX1",	// 81
	"CALLNX2",	// 82
	"CALLNX3",	// 83
	"CALLX0",	// 84
	"CALLX1",	// 85
	"CALLX2",	// 86
	"CALLX3",	// 87
	"STOP",		// 88
	"HALT",		// 89
	NULL
};

char *DebugCPUInstructions_Operand[] = {
	"",		//  0 (No operand)
	"%j",		//  1
	"%J",		//  2
	"%i",		//  3
	"%u",		//  4
	"%U",		//  5
	"%s",		//  6
	"%S",		//  7
	"A",		//  8
	"B",		//  9
	"%u",		// 10
	"[HL]",		// 11
	"[N+%u]",	// 12
	"[%U]",		// 13
	"[X]",		// 14
	"[Y]",		// 15
	"L",		// 16
	"H",		// 17
	"N",		// 18
	"SP",		// 19
	"BA",		// 20
	"HL",		// 21
	"X",		// 22
	"Y",		// 23
	"F",		// 24
	"I",		// 25
	"XI",		// 26
	"YI",		// 27
	"[X+%s]",	// 28
	"[Y+%s]",	// 29
	"[X+L]",	// 30
	"[Y+L]",	// 31
	"U",		// 32
	"V",		// 33
	"XI",		// 34
	"YI",		// 35
	"[SP+%s]",	// 36
	"PC",		// 37
	"%h",		// 38
	NULL
};

// %u = Unsigned 8-Bits
// %U = Unsigned 16-Bits
// %s = Signed 8-Bits
// %S = Signed 16-Bits
// %j = Relative jump (8-Bits)
// %J = Relative jump (16-Bits)
// %i = Interrupt

InstructionInfo DebugCPUInstructions_DX[8] = {
	{0x00, 1, 0, 0, 4, 0, 0, 0},	// ".DB %u"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// ".DB %u,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// ".DB %u,%u..."
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// ".DB %u,%u..."
	{0x00, 5, 0, 0, 4, 0, 4, 0},	// ".DB %u,%u..."
	{0x00, 6, 0, 0, 4, 0, 4, 0},	// ".DB %u,%u..."
	{0x00, 7, 0, 0, 4, 0, 4, 0},	// ".DB %u,%u..."
	{0x00, 8, 0, 0, 4, 0, 4, 0},	// ".DB %u,%u..."
};

InstructionInfo DebugCPUInstructions_XX[256] = {
	{0x00, 1, 4, 0, 8, 0, 8, 0},	// 00 __ "ADD A, A"
	{0x00, 1, 4, 0, 8, 0, 9, 0},	// 01 __ "ADD A, B"
	{0x00, 2, 4, 0, 8, 0,10, 1},	// 02 __ "ADD A, %u"
	{0x00, 1, 4, 0, 8, 0,11, 0},	// 03 __ "ADD A, [HL]"
	{0x00, 2, 4, 0, 8, 0,12, 1},	// 04 __ "ADD A, [N+%u]"
	{0x00, 3, 4, 0, 8, 0,13, 1},	// 05 __ "ADD A, [%U]"
	{0x00, 1, 4, 0, 8, 0,14, 0},	// 06 __ "ADD A, [X]"
	{0x00, 1, 4, 0, 8, 0,15, 0},	// 07 __ "ADD A, [Y]"
	{0x00, 1, 5, 0, 8, 0, 8, 0},	// 08 __ "ADC A, A"
	{0x00, 1, 5, 0, 8, 0, 9, 0},	// 09 __ "ADC A, B"
	{0x00, 2, 5, 0, 8, 0,10, 1},	// 0A __ "ADC A, %u"
	{0x00, 1, 5, 0, 8, 0,11, 0},	// 0B __ "ADC A, [HL]"
	{0x00, 2, 5, 0, 8, 0,12, 1},	// 0C __ "ADC A, [N+%u]"
	{0x00, 3, 5, 0, 8, 0,13, 1},	// 0D __ "ADC A, [%U]"
	{0x00, 1, 5, 0, 8, 0,14, 0},	// 0E __ "ADC A, [X]"
	{0x00, 1, 5, 0, 8, 0,15, 0},	// 0F __ "ADC A, [Y]"
	{0x00, 1, 6, 0, 8, 0, 8, 0},	// 10 __ "SUB A, A"
	{0x00, 1, 6, 0, 8, 0, 9, 0},	// 11 __ "SUB A, B"
	{0x00, 2, 6, 0, 8, 0,10, 1},	// 12 __ "SUB A, %u"
	{0x00, 1, 6, 0, 8, 0,11, 0},	// 13 __ "SUB A, [HL]"
	{0x00, 2, 6, 0, 8, 0,12, 1},	// 14 __ "SUB A, [N+%u]"
	{0x00, 3, 6, 0, 8, 0,13, 1},	// 15 __ "SUB A, [%U]"
	{0x00, 1, 6, 0, 8, 0,14, 0},	// 16 __ "SUB A, [X]"
	{0x00, 1, 6, 0, 8, 0,15, 0},	// 17 __ "SUB A, [Y]"
	{0x00, 1, 7, 0, 8, 0, 8, 0},	// 18 __ "SBC A, A"
	{0x00, 1, 7, 0, 8, 0, 9, 0},	// 19 __ "SBC A, B"
	{0x00, 2, 7, 0, 8, 0,10, 1},	// 1A __ "SBC A, %u"
	{0x00, 1, 7, 0, 8, 0,11, 0},	// 1B __ "SBC A, [HL]"
	{0x00, 2, 7, 0, 8, 0,12, 1},	// 1C __ "SBC A, [N+%u]"
	{0x00, 3, 7, 0, 8, 0,13, 1},	// 1D __ "SBC A, [%U]"
	{0x00, 1, 7, 0, 8, 0,14, 0},	// 1E __ "SBC A, [X]"
	{0x00, 1, 7, 0, 8, 0,15, 0},	// 1F __ "SBC A, [Y]"
	{0x00, 1, 8, 0, 8, 0, 8, 0},	// 20 __ "AND A, A"
	{0x00, 1, 8, 0, 8, 0, 9, 0},	// 21 __ "AND A, B"
	{0x00, 2, 8, 0, 8, 0,10, 1},	// 22 __ "AND A, %u"
	{0x00, 1, 8, 0, 8, 0,11, 0},	// 23 __ "AND A, [HL]"
	{0x00, 2, 8, 0, 8, 0,12, 1},	// 24 __ "AND A, [N+%u]"
	{0x00, 3, 8, 0, 8, 0,13, 1},	// 25 __ "AND A, [%U]"
	{0x00, 1, 8, 0, 8, 0,14, 0},	// 26 __ "AND A, [X]"
	{0x00, 1, 8, 0, 8, 0,15, 0},	// 27 __ "AND A, [Y]"
	{0x00, 1, 9, 0, 8, 0, 8, 0},	// 28 __ "OR A, A"
	{0x00, 1, 9, 0, 8, 0, 9, 0},	// 29 __ "OR A, B"
	{0x00, 2, 9, 0, 8, 0,10, 1},	// 2A __ "OR A, %u"
	{0x00, 1, 9, 0, 8, 0,11, 0},	// 2B __ "OR A, [HL]"
	{0x00, 2, 9, 0, 8, 0,12, 1},	// 2C __ "OR A, [N+%u]"
	{0x00, 3, 9, 0, 8, 0,13, 1},	// 2D __ "OR A, [%U]"
	{0x00, 1, 9, 0, 8, 0,14, 0},	// 2E __ "OR A, [X]"
	{0x00, 1, 9, 0, 8, 0,15, 0},	// 2F __ "OR A, [Y]"
	{0x00, 1,10, 0, 8, 0, 8, 0},	// 30 __ "CMP A, A"
	{0x00, 1,10, 0, 8, 0, 9, 0},	// 31 __ "CMP A, B"
	{0x00, 2,10, 0, 8, 0,10, 1},	// 32 __ "CMP A, %u"
	{0x00, 1,10, 0, 8, 0,11, 0},	// 33 __ "CMP A, [HL]"
	{0x00, 2,10, 0, 8, 0,12, 1},	// 34 __ "CMP A, [N+%u]"
	{0x00, 3,10, 0, 8, 0,13, 1},	// 35 __ "CMP A, [%U]"
	{0x00, 1,10, 0, 8, 0,14, 0},	// 36 __ "CMP A, [X]"
	{0x00, 1,10, 0, 8, 0,15, 0},	// 37 __ "CMP A, [Y]"
	{0x00, 1,11, 0, 8, 0, 8, 0},	// 38 __ "XOR A, A"
	{0x00, 1,11, 0, 8, 0, 9, 0},	// 39 __ "XOR A, B"
	{0x00, 2,11, 0, 8, 0,10, 1},	// 3A __ "XOR A, %u"
	{0x00, 1,11, 0, 8, 0,11, 0},	// 3B __ "XOR A, [HL]"
	{0x00, 2,11, 0, 8, 0,12, 1},	// 3C __ "XOR A, [N+%u]"
	{0x00, 3,11, 0, 8, 0,13, 1},	// 3D __ "XOR A, [%U]"
	{0x00, 1,11, 0, 8, 0,14, 0},	// 3E __ "XOR A, [X]"
	{0x00, 1,11, 0, 8, 0,15, 0},	// 3F __ "XOR A, [Y]"
	{0x00, 1, 2, 0, 8, 0, 8, 0},	// 40 __ "MOV A, A"
	{0x00, 1, 2, 0, 8, 0, 9, 0},	// 41 __ "MOV A, B"
	{0x00, 1, 2, 0, 8, 0,16, 0},	// 42 __ "MOV A, L"
	{0x00, 1, 2, 0, 8, 0,17, 0},	// 43 __ "MOV A, H"
	{0x00, 2, 2, 0, 8, 0,12, 1},	// 44 __ "MOV A, [N+%u]"
	{0x00, 1, 2, 0, 8, 0,11, 0},	// 45 __ "MOV A, [HL]"
	{0x00, 1, 2, 0, 8, 0,14, 0},	// 46 __ "MOV A, [X]"
	{0x00, 1, 2, 0, 8, 0,15, 0},	// 47 __ "MOV A, [Y]"
	{0x00, 1, 2, 0, 9, 0, 8, 0},	// 48 __ "MOV B, A"
	{0x00, 1, 2, 0, 9, 0, 9, 0},	// 49 __ "MOV B, B"
	{0x00, 1, 2, 0, 9, 0,16, 0},	// 4A __ "MOV B, L"
	{0x00, 1, 2, 0, 9, 0,17, 0},	// 4B __ "MOV B, H"
	{0x00, 2, 2, 0, 9, 0,12, 1},	// 4C __ "MOV B, [N+%u]"
	{0x00, 1, 2, 0, 9, 0,11, 0},	// 4D __ "MOV B, [HL]"
	{0x00, 1, 2, 0, 9, 0,14, 0},	// 4E __ "MOV B, [X]"
	{0x00, 1, 2, 0, 9, 0,15, 0},	// 4F __ "MOV B, [Y]"
	{0x00, 1, 2, 0,16, 0, 8, 0},	// 50 __ "MOV L, A"
	{0x00, 1, 2, 0,16, 0, 9, 0},	// 51 __ "MOV L, B"
	{0x00, 1, 2, 0,16, 0,16, 0},	// 52 __ "MOV L, L"
	{0x00, 1, 2, 0,16, 0,17, 0},	// 53 __ "MOV L, H"
	{0x00, 2, 2, 0,16, 0,12, 1},	// 54 __ "MOV L, [N+%u]"
	{0x00, 1, 2, 0,16, 0,11, 0},	// 55 __ "MOV L, [HL]"
	{0x00, 1, 2, 0,16, 0,14, 0},	// 56 __ "MOV L, [X]"
	{0x00, 1, 2, 0,16, 0,15, 0},	// 57 __ "MOV L, [Y]"
	{0x00, 1, 2, 0,17, 0, 8, 0},	// 58 __ "MOV H, A"
	{0x00, 1, 2, 0,17, 0, 9, 0},	// 59 __ "MOV H, B"
	{0x00, 1, 2, 0,17, 0,16, 0},	// 5A __ "MOV H, L"
	{0x00, 1, 2, 0,17, 0,17, 0},	// 5B __ "MOV H, H"
	{0x00, 2, 2, 0,17, 0,12, 1},	// 5C __ "MOV H, [N+%u]"
	{0x00, 1, 2, 0,17, 0,11, 0},	// 5D __ "MOV H, [HL]"
	{0x00, 1, 2, 0,17, 0,14, 0},	// 5E __ "MOV H, [X]"
	{0x00, 1, 2, 0,17, 0,15, 0},	// 5F __ "MOV H, [Y]"
	{0x00, 1, 2, 0,14, 0, 8, 0},	// 60 __ "MOV [X], A"
	{0x00, 1, 2, 0,14, 0, 9, 0},	// 61 __ "MOV [X], B"
	{0x00, 1, 2, 0,14, 0,16, 0},	// 62 __ "MOV [X], L"
	{0x00, 1, 2, 0,14, 0,17, 0},	// 63 __ "MOV [X], H"
	{0x00, 2, 2, 0,14, 0,12, 1},	// 64 __ "MOV [X], [N+%u]"
	{0x00, 1, 2, 0,14, 0,11, 0},	// 65 __ "MOV [X], [HL]"
	{0x00, 1, 2, 0,14, 0,14, 0},	// 66 __ "MOV [X], [X]"
	{0x00, 1, 2, 0,14, 0,15, 0},	// 67 __ "MOV [X], [Y]"
	{0x00, 1, 2, 0,11, 0, 8, 0},	// 68 __ "MOV [HL], A"
	{0x00, 1, 2, 0,11, 0, 9, 0},	// 69 __ "MOV [HL], B"
	{0x00, 1, 2, 0,11, 0,16, 0},	// 6A __ "MOV [HL], L"
	{0x00, 1, 2, 0,11, 0,17, 0},	// 6B __ "MOV [HL], H"
	{0x00, 2, 2, 0,11, 0,12, 1},	// 6C __ "MOV [HL], [N+%u]"
	{0x00, 1, 2, 0,11, 0,11, 0},	// 6D __ "MOV [HL], [HL]"
	{0x00, 1, 2, 0,11, 0,14, 0},	// 6E __ "MOV [HL], [X]"
	{0x00, 1, 2, 0,11, 0,15, 0},	// 6F __ "MOV [HL], [Y]"
	{0x00, 1, 2, 0,15, 0, 8, 0},	// 70 __ "MOV [Y], A"
	{0x00, 1, 2, 0,15, 0, 9, 0},	// 71 __ "MOV [Y], B"
	{0x00, 1, 2, 0,15, 0,16, 0},	// 72 __ "MOV [Y], L"
	{0x00, 1, 2, 0,15, 0,17, 0},	// 73 __ "MOV [Y], H"
	{0x00, 2, 2, 0,15, 0,12, 1},	// 74 __ "MOV [Y], [N+%u]"
	{0x00, 1, 2, 0,15, 0,11, 0},	// 75 __ "MOV [Y], [HL]"
	{0x00, 1, 2, 0,15, 0,14, 0},	// 76 __ "MOV [Y], [X]"
	{0x00, 1, 2, 0,15, 0,15, 0},	// 77 __ "MOV [Y], [Y]"
	{0x00, 2, 2, 0,12, 1, 8, 0},	// 78 __ "MOV [N+%u], A"
	{0x00, 2, 2, 0,12, 1, 9, 0},	// 79 __ "MOV [N+%u], B"
	{0x00, 2, 2, 0,12, 1,16, 0},	// 7A __ "MOV [N+%u], L"
	{0x00, 2, 2, 0,12, 1,17, 0},	// 7B __ "MOV [N+%u], H"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// 7C __ ".DB $7C,%u"
	{0x00, 2, 2, 0,12, 1,11, 0},	// 7D __ "MOV [N+%u], [HL]"
	{0x00, 2, 2, 0,12, 1,14, 0},	// 7E __ "MOV [N+%u], [X]"
	{0x00, 2, 2, 0,12, 1,15, 0},	// 7F __ "MOV [N+%u], [Y]"
	{0x00, 1,12, 0, 8, 0, 0, 0},	// 80 __ "INC A"
	{0x00, 1,12, 0, 9, 0, 0, 0},	// 81 __ "INC B"
	{0x00, 1,12, 0,16, 0, 0, 0},	// 82 __ "INC L"
	{0x00, 1,12, 0,17, 0, 0, 0},	// 83 __ "INC H"
	{0x00, 1,12, 0,18, 0, 0, 0},	// 84 __ "INC N"
	{0x00, 2,12, 0,12, 1, 0, 0},	// 85 __ "INC [N+%u]"
	{0x00, 1,12, 0,11, 0, 0, 0},	// 86 __ "INC [HL]"
	{0x00, 1,12, 0,19, 0, 0, 0},	// 87 __ "INC SP"
	{0x00, 1,13, 0, 8, 0, 0, 0},	// 88 __ "DEC A"
	{0x00, 1,13, 0, 9, 0, 0, 0},	// 89 __ "DEC B"
	{0x00, 1,13, 0,16, 0, 0, 0},	// 8A __ "DEC L"
	{0x00, 1,13, 0,17, 0, 0, 0},	// 8B __ "DEC H"
	{0x00, 1,13, 0,18, 0, 0, 0},	// 8C __ "DEC N"
	{0x00, 2,13, 0,12, 1, 0, 0},	// 8D __ "DEC [N+%u]"
	{0x00, 1,13, 0,11, 0, 0, 0},	// 8E __ "DEC [HL]"
	{0x00, 1,13, 0,19, 0, 0, 0},	// 8F __ "DEC SP"
	{0x00, 1,12, 0,20, 0, 0, 0},	// 90 __ "INC BA"
	{0x00, 1,12, 0,21, 0, 0, 0},	// 91 __ "INC HL"
	{0x00, 1,12, 0,22, 0, 0, 0},	// 92 __ "INC X"
	{0x00, 1,12, 0,23, 0, 0, 0},	// 93 __ "INC Y"
	{0x00, 1,14, 0, 8, 0, 9, 0},	// 94 __ "TST A, B"
	{0x00, 2,14, 0,11, 0, 4, 1},	// 95 __ "TST [HL], %u"
	{0x00, 2,14, 0, 8, 0, 4, 1},	// 96 __ "TST A, %u"
	{0x00, 2,14, 0, 9, 0, 4, 1},	// 97 __ "TST B, %u"
	{0x00, 1,13, 0,20, 0, 0, 0},	// 98 __ "DEC BA"
	{0x00, 1,13, 0,21, 0, 0, 0},	// 99 __ "DEC HL"
	{0x00, 1,13, 0,22, 0, 0, 0},	// 9A __ "DEC X"
	{0x00, 1,13, 0,23, 0, 0, 0},	// 9B __ "DEC Y"
	{0x00, 2, 8, 0,24, 0, 4, 1},	// 9C __ "AND F, %u"
	{0x00, 2, 9, 0,24, 0, 4, 1},	// 9D __ "OR F, %u"
	{0x00, 2,11, 0,24, 0, 4, 1},	// 9E __ "XOR F, %u"
	{0x00, 2, 2, 0,24, 0, 4, 1},	// 9F __ "MOV F, %u"
	{0x00, 1,16, 0,20, 0, 0, 0},	// A0 __ "PUSH BA"
	{0x00, 1,16, 0,21, 0, 0, 0},	// A1 __ "PUSH HL"
	{0x00, 1,16, 0,22, 0, 0, 0},	// A2 __ "PUSH X"
	{0x00, 1,16, 0,23, 0, 0, 0},	// A3 __ "PUSH Y"
	{0x00, 1,16, 0,18, 0, 0, 0},	// A4 __ "PUSH N"
	{0x00, 1,16, 0,25, 0, 0, 0},	// A5 __ "PUSH I"
	{0x00, 1,18, 0, 0, 0, 0, 0},	// A6 __ "PUSHX"
	{0x00, 1,16, 0,24, 0, 0, 0},	// A7 __ "PUSH F"
	{0x00, 1,17, 0,20, 0, 0, 0},	// A8 __ "POP BA"
	{0x00, 1,17, 0,21, 0, 0, 0},	// A9 __ "POP HL"
	{0x00, 1,17, 0,22, 0, 0, 0},	// AA __ "POP X"
	{0x00, 1,17, 0,23, 0, 0, 0},	// AB __ "POP Y"
	{0x00, 1,17, 0,18, 0, 0, 0},	// AC __ "POP N"
	{0x00, 1,17, 0,25, 0, 0, 0},	// AD __ "POP I"
	{0x00, 1,19, 0, 0, 0, 0, 0},	// AE __ "POPX"
	{0x00, 1,17, 0,24, 0, 0, 0},	// AF __ "POP F"
	{0x00, 2, 2, 0, 8, 0, 4, 1},	// B0 __ "MOV A, %u"
	{0x00, 2, 2, 0, 9, 0, 4, 1},	// B1 __ "MOV B, %u"
	{0x00, 2, 2, 0,16, 0, 4, 1},	// B2 __ "MOV L, %u"
	{0x00, 2, 2, 0,17, 0, 4, 1},	// B3 __ "MOV H, %u"
	{0x00, 2, 2, 0,18, 0, 4, 1},	// B4 __ "MOV N, %u"
	{0x00, 2, 2, 0,11, 0, 4, 1},	// B5 __ "MOV [HL], %u"
	{0x00, 2, 2, 0,14, 0, 4, 1},	// B6 __ "MOV [X], %u"
	{0x00, 2, 2, 0,15, 0, 4, 1},	// B7 __ "MOV [Y], %u"
	{0x00, 3, 2, 0,20, 0,13, 1},	// B8 __ "MOV BA, [%U]"
	{0x00, 3, 2, 0,21, 0,13, 1},	// B9 __ "MOV HL, [%U]"
	{0x00, 3, 2, 0,22, 0,13, 1},	// BA __ "MOV X, [%U]"
	{0x00, 3, 2, 0,23, 0,13, 1},	// BB __ "MOV Y, [%U]"
	{0x00, 3, 2, 0,13, 1,20, 0},	// BC __ "MOV [%U], BA"
	{0x00, 3, 2, 0,13, 1,21, 0},	// BD __ "MOV [%U], HL"
	{0x00, 3, 2, 0,13, 1,22, 0},	// BE __ "MOV [%U], X"
	{0x00, 3, 2, 0,13, 1,23, 0},	// BF __ "MOV [%U], Y"
	{0x00, 3, 4, 0,20, 0, 5, 1},	// C0 __ "ADD BA, %U"
	{0x00, 3, 4, 0,21, 0, 5, 1},	// C1 __ "ADD HL, %U"
	{0x00, 3, 4, 0,22, 0, 5, 1},	// C2 __ "ADD X, %U"
	{0x00, 3, 4, 0,23, 0, 5, 1},	// C3 __ "ADD Y, %U"
	{0x00, 3, 2, 0,20, 0, 5, 1},	// C4 __ "MOV BA, %U"
	{0x00, 3, 2, 0,21, 0, 5, 1},	// C5 __ "MOV HL, %U"
	{0x00, 3, 2, 0,22, 0, 5, 1},	// C6 __ "MOV X, %U"
	{0x00, 3, 2, 0,23, 0, 5, 1},	// C7 __ "MOV Y, %U"
	{0x00, 1,20, 0,20, 0,21, 0},	// C8 __ "XCHG BA, HL"
	{0x00, 1,20, 0,20, 0,22, 0},	// C9 __ "XCHG BA, X"
	{0x00, 1,20, 0,20, 0,23, 0},	// CA __ "XCHG BA, Y"
	{0x00, 1,20, 0,20, 0,19, 0},	// CB __ "XCHG BA, SP"
	{0x00, 1,20, 0, 8, 0, 9, 0},	// CC __ "XCHG A, B"
	{0x00, 1,20, 0, 8, 0,11, 0},	// CD __ "XCHG A, [HL]"
	{0x00, 2, 3, 0, 8, 0, 4, 1},	// CE __ EXPAND CE
	{0x00, 2, 3, 0, 9, 0, 4, 1},	// CF __ EXPAND CF
	{0x00, 3, 6, 0,20, 0, 5, 1},	// D0 __ "SUB BA, %U"
	{0x00, 3, 6, 0,21, 0, 5, 1},	// D1 __ "SUB HL, %U"
	{0x00, 3, 6, 0,22, 0, 5, 1},	// D2 __ "SUB X, %U"
	{0x00, 3, 6, 0,23, 0, 5, 1},	// D3 __ "SUB Y, %U"
	{0x00, 3,10, 0,20, 0, 5, 1},	// D4 __ "CMP BA, %U"
	{0x00, 3,10, 0,21, 0, 5, 1},	// D5 __ "CMP HL, %U"
	{0x00, 3,10, 0,22, 0, 5, 1},	// D6 __ "CMP X, %U"
	{0x00, 3,10, 0,23, 0, 5, 1},	// D7 __ "CMP Y, %U"
	{0x00, 3, 8, 0,12, 1, 4, 2},	// D8 __ "AND [N+%u], %u"
	{0x00, 3, 9, 0,12, 1, 4, 2},	// D9 __ "OR [N+%u], %u"
	{0x00, 3,11, 0,12, 1, 4, 2},	// DA __ "XOR [N+%u], %u"
	{0x00, 3,10, 0,12, 1, 4, 2},	// DB __ "CMP [N+%u], %u"
	{0x00, 3,14, 0,12, 1, 4, 2},	// DC __ "TST [N+%u], %u"
	{0x00, 3, 2, 0,12, 1, 4, 2},	// DD __ "MOV [N+%u], %u"
	{0x00, 1,21, 0, 0, 0, 0, 0},	// DE __ "PACK"
	{0x00, 1,22, 0, 0, 0, 0, 0},	// DF __ "UNPACK"
	{0x00, 2,24, 1, 1, 1, 0, 0},	// E0 __ "CALLCb %j"
	{0x00, 2,25, 1, 1, 1, 0, 0},	// E1 __ "CALLNCb %j"
	{0x00, 2,26, 1, 1, 1, 0, 0},	// E2 __ "CALLZb %j"
	{0x00, 2,27, 1, 1, 1, 0, 0},	// E3 __ "CALLNZb %j"
	{0x00, 2,28, 1, 1, 1, 0, 0},	// E4 __ "JCb %j"
	{0x00, 2,29, 1, 1, 1, 0, 0},	// E5 __ "JNCb %j"
	{0x00, 2,30, 1, 1, 1, 0, 0},	// E6 __ "JZb %j"
	{0x00, 2,31, 1, 1, 1, 0, 0},	// E7 __ "JNZb %j"
	{0x00, 3,24, 2, 2, 1, 0, 0},	// E8 __ "CALLCw %J"
	{0x00, 3,25, 2, 2, 1, 0, 0},	// E9 __ "CALLNCw %J"
	{0x00, 3,26, 2, 2, 1, 0, 0},	// EA __ "CALLZw %J"
	{0x00, 3,27, 2, 2, 1, 0, 0},	// EB __ "CALLNZw %J"
	{0x00, 3,28, 2, 2, 1, 0, 0},	// EC __ "JCw %J"
	{0x00, 3,29, 2, 2, 1, 0, 0},	// ED __ "JNCw %J"
	{0x00, 3,30, 2, 2, 1, 0, 0},	// EE __ "JZw %J"
	{0x00, 3,31, 2, 2, 1, 0, 0},	// EF __ "JNZw %J"
	{0x00, 2,32, 1, 1, 1, 0, 0},	// F0 __ "CALLb %j"
	{0x00, 2,33, 1, 1, 1, 0, 0},	// F1 __ "JMPb %j"
	{0x00, 3,32, 2, 2, 1, 0, 0},	// F2 __ "CALLw %J"
	{0x00, 3,33, 2, 2, 1, 0, 0},	// F3 __ "JMPw %J"
	{0x00, 1,33, 0,21, 0, 0, 0},	// F4 __ "JMP HL"
	{0x00, 2,34, 0, 1, 1, 0, 0},	// F5 __ "JDBNZ %j"
	{0x00, 1,23, 0, 8, 0, 0, 0},	// F6 __ "SWAP A"
	{0x00, 1,23, 0,11, 0, 0, 0},	// F7 __ "SWAP [HL]"
	{0x00, 1,35, 0, 0, 0, 0, 0},	// F8 __ "RET"
	{0x00, 1,36, 0, 0, 0, 0, 0},	// F9 __ "RETI"
	{0x00, 1,37, 0, 0, 0, 0, 0},	// FA __ "RETSKIP"
	{0x00, 3,32, 0, 5, 1, 0, 0},	// FB __ "CALL [%U]"
	{0x00, 2,38, 0, 3, 1, 0, 0},	// FC __ "CINT %i"
	{0x00, 2,39, 0, 3, 1, 0, 0},	// FD __ "JINT %i"
	{0x00, 1, 0, 0, 4, 0, 0, 0},	// FE __ ".DB $FE"
	{0x00, 1, 1, 0, 0, 0, 0, 0},	// FF __ "NOP"
};

InstructionInfo DebugCPUInstructions_CE[256] = {
	{0x00, 3, 4, 0, 8, 0,28, 2},	// CE 00 "ADD A, [X+%s]"
	{0x00, 3, 4, 0, 8, 0,29, 2},	// CE 01 "ADD A, [Y+%s]"
	{0x00, 2, 4, 0, 8, 0,30, 0},	// CE 02 "ADD A, [X+L]"
	{0x00, 2, 4, 0, 8, 0,31, 0},	// CE 03 "ADD A, [Y+L]"
	{0x00, 2, 4, 0,11, 0, 8, 0},	// CE 04 "ADD [HL], A"
	{0x00, 3, 4, 0,11, 0, 4, 2},	// CE 05 "ADD [HL], %u"
	{0x00, 2, 4, 0,11, 0,14, 0},	// CE 06 "ADD [HL], [X]"
	{0x00, 2, 4, 0,11, 0,15, 0},	// CE 07 "ADD [HL], [Y]"
	{0x00, 3, 5, 0, 8, 0,28, 2},	// CE 08 "ADC A, [X+%s]"
	{0x00, 3, 5, 0, 8, 0,29, 2},	// CE 09 "ADC A, [Y+%s]"
	{0x00, 2, 5, 0, 8, 0,30, 0},	// CE 0A "ADC A, [X+L]"
	{0x00, 2, 5, 0, 8, 0,31, 0},	// CE 0B "ADC A, [Y+L]"
	{0x00, 2, 5, 0,11, 0, 8, 0},	// CE 0C "ADC [HL], A"
	{0x00, 3, 5, 0,11, 0, 4, 2},	// CE 0D "ADC [HL], %u"
	{0x00, 2, 5, 0,11, 0,14, 0},	// CE 0E "ADC [HL], [X]"
	{0x00, 2, 5, 0,11, 0,15, 0},	// CE 0F "ADC [HL], [Y]"
	{0x00, 3, 6, 0, 8, 0,28, 2},	// CE 10 "SUB A, [X+%s]"
	{0x00, 3, 6, 0, 8, 0,29, 2},	// CE 11 "SUB A, [Y+%s]"
	{0x00, 2, 6, 0, 8, 0,30, 0},	// CE 12 "SUB A, [X+L]"
	{0x00, 2, 6, 0, 8, 0,31, 0},	// CE 13 "SUB A, [Y+L]"
	{0x00, 2, 6, 0,11, 0, 8, 0},	// CE 14 "SUB [HL], A"
	{0x00, 3, 6, 0,11, 0, 4, 2},	// CE 15 "SUB [HL], %u"
	{0x00, 2, 6, 0,11, 0,14, 0},	// CE 16 "SUB [HL], [X]"
	{0x00, 2, 6, 0,11, 0,15, 0},	// CE 17 "SUB [HL], [Y]"
	{0x00, 3, 7, 0, 8, 0,28, 2},	// CE 18 "SBC A, [X+%s]"
	{0x00, 3, 7, 0, 8, 0,29, 2},	// CE 19 "SBC A, [Y+%s]"
	{0x00, 2, 7, 0, 8, 0,30, 0},	// CE 1A "SBC A, [X+L]"
	{0x00, 2, 7, 0, 8, 0,31, 0},	// CE 1B "SBC A, [Y+L]"
	{0x00, 2, 7, 0,11, 0, 8, 0},	// CE 1C "SBC [HL], A"
	{0x00, 3, 7, 0,11, 0, 4, 2},	// CE 1D "SBC [HL], %u"
	{0x00, 2, 7, 0,11, 0,14, 0},	// CE 1E "SBC [HL], [X]"
	{0x00, 2, 7, 0,11, 0,15, 0},	// CE 1F "SBC [HL], [Y]"
	{0x00, 3, 8, 0, 8, 0,28, 2},	// CE 20 "AND A, [X+%s]"
	{0x00, 3, 8, 0, 8, 0,29, 2},	// CE 21 "AND A, [Y+%s]"
	{0x00, 2, 8, 0, 8, 0,30, 0},	// CE 22 "AND A, [X+L]"
	{0x00, 2, 8, 0, 8, 0,31, 0},	// CE 23 "AND A, [Y+L]"
	{0x00, 2, 8, 0,11, 0, 8, 0},	// CE 24 "AND [HL], A"
	{0x00, 3, 8, 0,11, 0, 4, 2},	// CE 25 "AND [HL], %u"
	{0x00, 2, 8, 0,11, 0,14, 0},	// CE 26 "AND [HL], [X]"
	{0x00, 2, 8, 0,11, 0,15, 0},	// CE 27 "AND [HL], [Y]"
	{0x00, 3, 9, 0, 8, 0,28, 2},	// CE 28 "OR A, [X+%s]"
	{0x00, 3, 9, 0, 8, 0,29, 2},	// CE 29 "OR A, [Y+%s]"
	{0x00, 2, 9, 0, 8, 0,30, 0},	// CE 2A "OR A, [X+L]"
	{0x00, 2, 9, 0, 8, 0,31, 0},	// CE 2B "OR A, [Y+L]"
	{0x00, 2, 9, 0,11, 0, 8, 0},	// CE 2C "OR [HL], A"
	{0x00, 3, 9, 0,11, 0, 4, 2},	// CE 2D "OR [HL], %u"
	{0x00, 2, 9, 0,11, 0,14, 0},	// CE 2E "OR [HL], [X]"
	{0x00, 2, 9, 0,11, 0,15, 0},	// CE 2F "OR [HL], [Y]"
	{0x00, 3,10, 0, 8, 0,28, 2},	// CE 30 "CMP A, [X+%s]"
	{0x00, 3,10, 0, 8, 0,29, 2},	// CE 31 "CMP A, [Y+%s]"
	{0x00, 2,10, 0, 8, 0,30, 0},	// CE 32 "CMP A, [X+L]"
	{0x00, 2,10, 0, 8, 0,31, 0},	// CE 33 "CMP A, [Y+L]"
	{0x00, 2,10, 0,11, 0, 8, 0},	// CE 34 "CMP [HL], A"
	{0x00, 3,10, 0,11, 0, 4, 2},	// CE 35 "CMP [HL], %u"
	{0x00, 2,10, 0,11, 0,14, 0},	// CE 36 "CMP [HL], [X]"
	{0x00, 2,10, 0,11, 0,15, 0},	// CE 37 "CMP [HL], [Y]"
	{0x00, 3,10, 0, 8, 0,28, 2},	// CE 38 "XOR A, [X+%s]"
	{0x00, 3,10, 0, 8, 0,29, 2},	// CE 39 "XOR A, [Y+%s]"
	{0x00, 2,10, 0, 8, 0,30, 0},	// CE 3A "XOR A, [X+L]"
	{0x00, 2,10, 0, 8, 0,31, 0},	// CE 3B "XOR A, [Y+L]"
	{0x00, 2,10, 0,11, 0, 8, 0},	// CE 3C "XOR [HL], A"
	{0x00, 3,10, 0,11, 0, 4, 2},	// CE 3D "XOR [HL], %u"
	{0x00, 2,10, 0,11, 0,14, 0},	// CE 3E "XOR [HL], [X]"
	{0x00, 2,10, 0,11, 0,15, 0},	// CE 3F "XOR [HL], [Y]"
	{0x00, 3, 2, 0, 8, 0,28, 2},	// CE 40 "MOV A, [X+%s]"
	{0x00, 3, 2, 0, 8, 0,29, 2},	// CE 41 "MOV A, [Y+%s]"
	{0x00, 2, 2, 0, 8, 0,30, 0},	// CE 42 "MOV A, [X+L]"
	{0x00, 2, 2, 0, 8, 0,31, 0},	// CE 43 "MOV A, [Y+L]"
	{0x00, 3, 2, 0,28, 2, 8, 0},	// CE 44 "MOV [X+%s], A"
	{0x00, 3, 2, 0,29, 2, 8, 0},	// CE 45 "MOV [Y+%s], A"
	{0x00, 2, 2, 0,30, 0, 8, 0},	// CE 46 "MOV [X+L], A"
	{0x00, 2, 2, 0,31, 0, 8, 0},	// CE 47 "MOV [Y+L], A"
	{0x00, 3, 2, 0, 9, 0,28, 2},	// CE 48 "MOV B, [X+%s]"
	{0x00, 3, 2, 0, 9, 0,29, 2},	// CE 49 "MOV B, [Y+%s]"
	{0x00, 2, 2, 0, 9, 0,30, 0},	// CE 4A "MOV B, [X+L]"
	{0x00, 2, 2, 0, 9, 0,31, 0},	// CE 4B "MOV B, [Y+L]"
	{0x00, 3, 2, 0,28, 2, 9, 0},	// CE 4C "MOV [X+%s], B"
	{0x00, 3, 2, 0,29, 2, 9, 0},	// CE 4D "MOV [Y+%s], B"
	{0x00, 2, 2, 0,30, 0, 9, 0},	// CE 4E "MOV [X+L], B"
	{0x00, 2, 2, 0,31, 0, 9, 0},	// CE 4F "MOV [Y+L], B"
	{0x00, 3, 2, 0,16, 0,28, 2},	// CE 50 "MOV L, [X+%s]"
	{0x00, 3, 2, 0,16, 0,29, 2},	// CE 51 "MOV L, [Y+%s]"
	{0x00, 2, 2, 0,16, 0,30, 0},	// CE 52 "MOV L, [X+L]"
	{0x00, 2, 2, 0,16, 0,31, 0},	// CE 53 "MOV L, [Y+L]"
	{0x00, 3, 2, 0,28, 2,16, 0},	// CE 54 "MOV [X+%s], L"
	{0x00, 3, 2, 0,29, 2,16, 0},	// CE 55 "MOV [Y+%s], L"
	{0x00, 2, 2, 0,30, 0,16, 0},	// CE 56 "MOV [X+L], L"
	{0x00, 2, 2, 0,31, 0,16, 0},	// CE 57 "MOV [Y+L], L"
	{0x00, 3, 2, 0,17, 0,28, 2},	// CE 58 "MOV H, [X+%s]"
	{0x00, 3, 2, 0,17, 0,29, 2},	// CE 59 "MOV H, [Y+%s]"
	{0x00, 2, 2, 0,17, 0,30, 0},	// CE 5A "MOV H, [X+L]"
	{0x00, 2, 2, 0,17, 0,31, 0},	// CE 5B "MOV H, [Y+L]"
	{0x00, 3, 2, 0,28, 2,17, 0},	// CE 5C "MOV [X+%s], H"
	{0x00, 3, 2, 0,29, 2,17, 0},	// CE 5D "MOV [Y+%s], H"
	{0x00, 2, 2, 0,30, 0,17, 0},	// CE 5E "MOV [X+L], H"
	{0x00, 2, 2, 0,31, 0,17, 0},	// CE 5F "MOV [Y+L], H"
	{0x00, 3, 2, 0,11, 0,28, 2},	// CE 60 "MOV [HL], [X+%s]"
	{0x00, 3, 2, 0,11, 0,29, 2},	// CE 61 "MOV [HL], [Y+%s]"
	{0x00, 2, 2, 0,11, 0,30, 0},	// CE 62 "MOV [HL], [X+L]"
	{0x00, 2, 2, 0,11, 0,31, 0},	// CE 63 "MOV [HL], [Y+L]"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 64 ".DB $CE,$65,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 65 ".DB $CE,$66,%u,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 66 ".DB $CE,$67,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 67 ".DB $CE,$68,%u"
	{0x00, 3, 2, 0,14, 0,28, 2},	// CE 68 "MOV [X], [X+%s]"
	{0x00, 3, 2, 0,14, 0,29, 2},	// CE 69 "MOV [X], [Y+%s]"
	{0x00, 2, 2, 0,14, 0,30, 0},	// CE 6A "MOV [X], [X+L]"
	{0x00, 2, 2, 0,14, 0,31, 0},	// CE 6B "MOV [X], [Y+L]"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 6C ".DB $CE,$6C,%u,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 6D ".DB $CE,$6D,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 6E ".DB $CE,$6E,%u"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 6F ".DB $CE,$6F"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 70 ".DB $CE,$70,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 71 ".DB $CE,$71,%u"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 72 ".DB $CE,$72"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 73 ".DB $CE,$73"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 74 ".DB $CE,$74,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 75 ".DB $CE,$75,%u"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 76 ".DB $CE,$76"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 77 ".DB $CE,$77"
	{0x00, 3, 2, 0,15, 0,28, 2},	// CE 78 "MOV [Y], [X+%s]"
	{0x00, 3, 2, 0,15, 0,29, 2},	// CE 79 "MOV [Y], [Y+%s]"
	{0x00, 2, 2, 0,15, 0,30, 0},	// CE 7A "MOV [Y], [X+L]"
	{0x00, 2, 2, 0,15, 0,31, 0},	// CE 7B "MOV [Y], [Y+L]"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 7C ".DB $CE,$7C,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE 7D ".DB $CE,$7D,%u"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 7E ".DB $CE,$7E"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 7F ".DB $CE,$7F"
	{0x00, 2,40, 0, 8, 0, 0, 0},	// CE 80 "SAL A"
	{0x00, 2,40, 0, 9, 0, 0, 0},	// CE 81 "SAL B"
	{0x00, 3,40, 0,12, 2, 0, 0},	// CE 82 "SAL [N+%u]"
	{0x00, 2,40, 0,11, 0, 0, 0},	// CE 83 "SAL [HL]"
	{0x00, 2,41, 0, 8, 0, 0, 0},	// CE 84 "SHL A"
	{0x00, 2,41, 0, 9, 0, 0, 0},	// CE 85 "SHL B"
	{0x00, 3,41, 0,12, 2, 0, 0},	// CE 86 "SHL [N+%u]"
	{0x00, 2,41, 0,11, 0, 0, 0},	// CE 87 "SHL [HL]"
	{0x00, 2,42, 0, 8, 0, 0, 0},	// CE 88 "SAR A"
	{0x00, 2,42, 0, 9, 0, 0, 0},	// CE 89 "SAR B"
	{0x00, 3,42, 0,12, 2, 0, 0},	// CE 8A "SAR [N+%u]"
	{0x00, 2,42, 0,11, 0, 0, 0},	// CE 8B "SAR [HL]"
	{0x00, 2,43, 0, 8, 0, 0, 0},	// CE 8C "SHR A"
	{0x00, 2,43, 0, 9, 0, 0, 0},	// CE 8D "SHR B"
	{0x00, 3,43, 0,12, 2, 0, 0},	// CE 8E "SHR [N+%u]"
	{0x00, 2,43, 0,11, 0, 0, 0},	// CE 8F "SHR [HL]"
	{0x00, 2,44, 0, 8, 0, 0, 0},	// CE 90 "ROLC A"
	{0x00, 2,44, 0, 9, 0, 0, 0},	// CE 91 "ROLC B"
	{0x00, 3,44, 0,12, 2, 0, 0},	// CE 92 "ROLC [N+%u]"
	{0x00, 2,44, 0,11, 0, 0, 0},	// CE 93 "ROLC [HL]"
	{0x00, 2,45, 0, 8, 0, 0, 0},	// CE 94 "ROL A"
	{0x00, 2,45, 0, 9, 0, 0, 0},	// CE 95 "ROL B"
	{0x00, 3,45, 0,12, 2, 0, 0},	// CE 96 "ROL [N+%u]"
	{0x00, 2,45, 0,11, 0, 0, 0},	// CE 97 "ROL [HL]"
	{0x00, 2,46, 0, 8, 0, 0, 0},	// CE 98 "RORC A"
	{0x00, 2,46, 0, 9, 0, 0, 0},	// CE 99 "RORC B"
	{0x00, 3,46, 0,12, 2, 0, 0},	// CE 9A "RORC [N+%u]"
	{0x00, 2,46, 0,11, 0, 0, 0},	// CE 9B "RORC [HL]"
	{0x00, 2,47, 0, 8, 0, 0, 0},	// CE 9C "ROR A"
	{0x00, 2,47, 0, 9, 0, 0, 0},	// CE 9D "ROR B"
	{0x00, 3,47, 0,12, 2, 0, 0},	// CE 9E "ROR [N+%u]"
	{0x00, 2,47, 0,11, 0, 0, 0},	// CE 9F "ROR [HL]"
	{0x00, 2,48, 0, 8, 0, 0, 0},	// CE A0 "NOT A"
	{0x00, 2,48, 0, 9, 0, 0, 0},	// CE A1 "NOT B"
	{0x00, 3,48, 0,12, 2, 0, 0},	// CE A2 "NOT [N+%u]"
	{0x00, 2,48, 0,11, 0, 0, 0},	// CE A3 "NOT [HL]"
	{0x00, 2,49, 0, 8, 0, 0, 0},	// CE A4 "NEG A"
	{0x00, 2,49, 0, 9, 0, 0, 0},	// CE A5 "NEG B"
	{0x00, 3,49, 0,12, 2, 0, 0},	// CE A6 "NEG [N+%u]"
	{0x00, 2,49, 0,11, 0, 0, 0},	// CE A7 "NEG [HL]"
	{0x00, 2,15, 0,20, 0, 8, 0},	// CE A8 "EX BA, A"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE A9 ".DB $CE,$A9"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE AA ".DB $CE,$AA"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE AB ".DB $CE,$AB"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE AC ".DB $CE,$AC"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE AD ".DB $CE,$AD"
	{0x00, 2,89, 0, 0, 0, 0, 0},	// CE AE "HALT"
	{0x00, 2,88, 0, 0, 0, 0, 0},	// CE AF "STOP"
	{0x00, 3, 8, 0, 9, 0,10, 2},	// CE B0 "AND B, %u"
	{0x00, 3, 8, 0,16, 0,10, 2},	// CE B1 "AND L, %u"
	{0x00, 3, 8, 0,17, 0,10, 2},	// CE B2 "AND H, %u"
	{0x00, 2, 0, 0, 0, 0, 0, 0},	// CE B3 ".DB $CE,$B3"
	{0x00, 3, 9, 0, 9, 0,10, 2},	// CE B4 "OR B, %u"
	{0x00, 3, 9, 0,16, 0,10, 2},	// CE B5 "OR L, %u"
	{0x00, 3, 9, 0,17, 0,10, 2},	// CE B6 "OR H, %u"
	{0x00, 2, 0, 0, 0, 0, 0, 0},	// CE B7 ".DB $CE,$B7"
	{0x00, 3,11, 0, 9, 0,10, 2},	// CE B8 "XOR B, %u"
	{0x00, 3,11, 0,16, 0,10, 2},	// CE B9 "XOR L, %u"
	{0x00, 3,11, 0,17, 0,10, 2},	// CE BA "XOR H, %u"
	{0x00, 2, 0, 0, 0, 0, 0, 0},	// CE BB ".DB $CE,$B3"
	{0x00, 3,10, 0, 9, 0,10, 2},	// CE BC "CMP B, %u"
	{0x00, 3,10, 0,16, 0,10, 2},	// CE BD "CMP L, %u"
	{0x00, 3,10, 0,17, 0,10, 2},	// CE BE "CMP H, %u"
	{0x00, 3,10, 0,18, 0,10, 2},	// CE BF "CMP N, %u"
	{0x00, 2, 2, 0, 8, 0,18, 0},	// CE C0 "MOV A, N"
	{0x00, 2, 2, 0, 8, 0,24, 0},	// CE C1 "MOV A, F"
	{0x00, 2, 2, 0,18, 0, 8, 0},	// CE C2 "MOV N, A"
	{0x00, 2, 2, 0,24, 0, 8, 0},	// CE C3 "MOV F, A"
	{0x00, 3, 2, 0,32, 0, 4, 2},	// CE C4 "MOV U, %u"
	{0x00, 3, 2, 0,25, 0, 4, 2},	// CE C5 "MOV I, %u"
	{0x00, 3, 2, 0,34, 0, 4, 2},	// CE C6 "MOV XI, %u"
	{0x00, 3, 2, 0,35, 0, 4, 2},	// CE C7 "MOV YI, %u"
	{0x00, 2, 2, 0, 8, 0,33, 0},	// CE C8 "MOV A, V"
	{0x00, 2, 2, 0, 8, 0,25, 0},	// CE C9 "MOV A, I"
	{0x00, 2, 2, 0, 8, 0,34, 0},	// CE CA "MOV A, XI"
	{0x00, 2, 2, 0, 8, 0,35, 0},	// CE CB "MOV A, YI"
	{0x00, 2, 2, 0,32, 0, 8, 0},	// CE CC "MOV U, A"
	{0x00, 2, 2, 0,25, 0, 8, 0},	// CE CD "MOV I, A"
	{0x00, 2, 2, 0,34, 0, 8, 0},	// CE CE "MOV XI, A"
	{0x00, 2, 2, 0,35, 0, 8, 0},	// CE CF "MOV YI, A"
	{0x00, 4, 2, 0, 8, 0,13, 2},	// CE D0 "MOV A, [%U]"
	{0x00, 4, 2, 0, 9, 0,13, 2},	// CE D1 "MOV B, [%U]"
	{0x00, 4, 2, 0,16, 0,13, 2},	// CE D2 "MOV L, [%U]"
	{0x00, 4, 2, 0,17, 0,13, 2},	// CE D3 "MOV H, [%U]"
	{0x00, 4, 2, 0,13, 2, 8, 0},	// CE D4 "MOV [%U], A"
	{0x00, 4, 2, 0,13, 2, 9, 0},	// CE D5 "MOV [%U], B"
	{0x00, 4, 2, 0,13, 2,16, 0},	// CE D6 "MOV [%U], L"
	{0x00, 4, 2, 0,13, 2,17, 0},	// CE D7 "MOV [%U], H"
	{0x00, 2,50, 0,16, 0, 8, 0},	// CE D8 "MUL L, A"
	{0x00, 2,51, 0,21, 0, 8, 0},	// CE D9 "DIV HL, A"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE DA ".DB $CE,$DA,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE DB ".DB $CE,$DB,%u"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE DC ".DB $CE,$DC"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE DD ".DB $CE,$DD"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE DE ".DB $CE,$DE,%u"
	{0x00, 3, 0, 0, 4, 0, 4, 0},	// CE DF ".DB $CE,$DF,%u"
	{0x00, 3,56, 0,38, 2, 0, 0},	// CE E0 "JL %h"
	{0x00, 3,57, 0,38, 2, 0, 0},	// CE E1 "JLE %h"
	{0x00, 3,58, 0,38, 2, 0, 0},	// CE E2 "JG %h"
	{0x00, 3,59, 0,38, 2, 0, 0},	// CE E3 "JGE %h"
	{0x00, 3,60, 0,38, 2, 0, 0},	// CE E4 "JO %h"
	{0x00, 3,61, 0,38, 2, 0, 0},	// CE E5 "JNO %h"
	{0x00, 3,62, 0,38, 2, 0, 0},	// CE E6 "JNS %h"
	{0x00, 3,63, 0,38, 2, 0, 0},	// CE E7 "JS %h"
	{0x00, 3,64, 0,38, 2, 0, 0},	// CE E8 "JNX0 %h"
	{0x00, 3,65, 0,38, 2, 0, 0},	// CE E9 "JNX1 %h"
	{0x00, 3,66, 0,38, 2, 0, 0},	// CE EA "JNX2 %h"
	{0x00, 3,67, 0,38, 2, 0, 0},	// CE EB "JNX3 %h"
	{0x00, 3,68, 0,38, 2, 0, 0},	// CE EC "JX0 %h"
	{0x00, 2,69, 0,38, 2, 0, 0},	// CE ED "JX1 %h"
	{0x00, 3,70, 0,38, 2, 0, 0},	// CE EE "JX2 %h"
	{0x00, 3,71, 0,38, 2, 0, 0},	// CE EF "JX3 %h"
	{0x00, 3,72, 0,38, 2, 0, 0},	// CE F0 "CALLL %h"
	{0x00, 3,73, 0,38, 2, 0, 0},	// CE F1 "CALLLE %h"
	{0x00, 3,74, 0,38, 2, 0, 0},	// CE F2 "CALLG %h"
	{0x00, 3,75, 0,38, 2, 0, 0},	// CE F3 "CALLGE %h"
	{0x00, 3,76, 0,38, 2, 0, 0},	// CE F4 "CALLO %h"
	{0x00, 3,77, 0,38, 2, 0, 0},	// CE F5 "CALLNO %h"
	{0x00, 3,78, 0,38, 2, 0, 0},	// CE F6 "CALLNS %h"
	{0x00, 3,79, 0,38, 2, 0, 0},	// CE F7 "CALLS %h"
	{0x00, 3,80, 0,38, 2, 0, 0},	// CE F8 "CALLNX0 %h"
	{0x00, 3,81, 0,38, 2, 0, 0},	// CE F9 "CALLNX1 %h"
	{0x00, 3,82, 0,38, 2, 0, 0},	// CE FA "CALLNX2 %h"
	{0x00, 3,83, 0,38, 2, 0, 0},	// CE FB "CALLNX3 %h"
	{0x00, 3,84, 0,38, 2, 0, 0},	// CE FC "CALLX0 %h"
	{0x00, 3,85, 0,38, 2, 0, 0},	// CE FD "CALLX1 %h"
	{0x00, 3,86, 0,38, 2, 0, 0},	// CE FE "CALLX2 %h"
	{0x00, 3,87, 0,38, 2, 0, 0}	// CE FF "CALLX3 %h"
};

InstructionInfo DebugCPUInstructions_CF[256] = {
	{0x00, 2, 4, 0,20, 0,20, 0},	// CE 00 "ADD BA, BA"
	{0x00, 2, 4, 0,20, 0,21, 0},	// CE 01 "ADD BA, HL"
	{0x00, 2, 4, 0,20, 0,22, 0},	// CE 02 "ADD BA, X"
	{0x00, 2, 4, 0,20, 0,23, 0},	// CE 03 "ADD BA, Y"
	{0x00, 2, 5, 0,20, 0,20, 0},	// CE 04 "ADC BA, BA"
	{0x00, 2, 5, 0,20, 0,21, 0},	// CE 05 "ADC BA, HL"
	{0x00, 2, 5, 0,20, 0,22, 0},	// CE 06 "ADC BA, X"
	{0x00, 2, 5, 0,20, 0,23, 0},	// CE 07 "ADC BA, Y"
	{0x00, 2, 6, 0,20, 0,20, 0},	// CE 08 "SUB BA, BA"
	{0x00, 2, 6, 0,20, 0,21, 0},	// CE 09 "SUB BA, HL"
	{0x00, 2, 6, 0,20, 0,22, 0},	// CE 0A "SUB BA, X"
	{0x00, 2, 6, 0,20, 0,23, 0},	// CE 0B "SUB BA, Y"
	{0x00, 2, 7, 0,20, 0,20, 0},	// CE 0C "SBC BA, BA"
	{0x00, 2, 7, 0,20, 0,21, 0},	// CE 0D "SBC BA, HL"
	{0x00, 2, 7, 0,20, 0,22, 0},	// CE 0E "SBC BA, X"
	{0x00, 2, 7, 0,20, 0,23, 0},	// CE 0F "SBC BA, Y"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 10 ".DB $CF,$10"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 11 ".DB $CF,$11"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 12 ".DB $CF,$12"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 13 ".DB $CF,$13"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 14 ".DB $CF,$14"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 15 ".DB $CF,$15"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 16 ".DB $CF,$16"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 17 ".DB $CF,$17"
	{0x00, 2,10, 0,20, 0,20, 0},	// CE 18 "CMP BA, BA"
	{0x00, 2,10, 0,20, 0,21, 0},	// CE 19 "CMP BA, HL"
	{0x00, 2,10, 0,20, 0,22, 0},	// CE 1A "CMP BA, X"
	{0x00, 2,10, 0,20, 0,23, 0},	// CE 1B "CMP BA, Y"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 1C ".DB $CF,$1C"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 1D ".DB $CF,$1D"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 1E ".DB $CF,$1E"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 1F ".DB $CF,$1F"
	{0x00, 2, 4, 0,21, 0,20, 0},	// CE 20 "ADD HL, BA"
	{0x00, 2, 4, 0,21, 0,21, 0},	// CE 21 "ADD HL, HL"
	{0x00, 2, 4, 0,21, 0,22, 0},	// CE 22 "ADD HL, X"
	{0x00, 2, 4, 0,21, 0,23, 0},	// CE 23 "ADD HL, Y"
	{0x00, 2, 5, 0,21, 0,20, 0},	// CE 24 "ADC HL, BA"
	{0x00, 2, 5, 0,21, 0,21, 0},	// CE 25 "ADC HL, HL"
	{0x00, 2, 5, 0,21, 0,22, 0},	// CE 26 "ADC HL, X"
	{0x00, 2, 5, 0,21, 0,23, 0},	// CE 27 "ADC HL, Y"
	{0x00, 2, 6, 0,21, 0,20, 0},	// CE 28 "SUB HL, BA"
	{0x00, 2, 6, 0,21, 0,21, 0},	// CE 29 "SUB HL, HL"
	{0x00, 2, 6, 0,21, 0,22, 0},	// CE 2A "SUB HL, X"
	{0x00, 2, 6, 0,21, 0,23, 0},	// CE 2B "SUB HL, Y"
	{0x00, 2, 7, 0,21, 0,20, 0},	// CE 2C "SBC HL, BA"
	{0x00, 2, 7, 0,21, 0,21, 0},	// CE 2D "SBC HL, HL"
	{0x00, 2, 7, 0,21, 0,22, 0},	// CE 2E "SBC HL, X"
	{0x00, 2, 7, 0,21, 0,23, 0},	// CE 2F "SBC HL, Y"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 30 ".DB $CF,$30"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 31 ".DB $CF,$31"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 32 ".DB $CF,$32"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 33 ".DB $CF,$33"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 34 ".DB $CF,$34"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 35 ".DB $CF,$35"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 36 ".DB $CF,$36"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 37 ".DB $CF,$37"
	{0x00, 2,10, 0,21, 0,20, 0},	// CE 38 "CMP HL, BA"
	{0x00, 2,10, 0,21, 0,21, 0},	// CE 39 "CMP HL, HL"
	{0x00, 2,10, 0,21, 0,22, 0},	// CE 3A "CMP HL, X"
	{0x00, 2,10, 0,21, 0,23, 0},	// CE 3B "CMP HL, Y"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 3C ".DB $CF,$3C"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 3D ".DB $CF,$3D"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 3E ".DB $CF,$3E"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 3F ".DB $CF,$3F"
	{0x00, 2, 4, 0,22, 0,20, 0},	// CE 40 "ADD X, BA"
	{0x00, 2, 4, 0,22, 0,21, 0},	// CE 41 "ADD X, HL"
	{0x00, 2, 4, 0,23, 0,20, 0},	// CE 42 "ADD Y, BA"
	{0x00, 2, 4, 0,23, 0,21, 0},	// CE 43 "ADD Y, HL"
	{0x00, 2, 4, 0,19, 0,20, 0},	// CE 44 "ADD SP, BA"
	{0x00, 2, 4, 0,19, 0,21, 0},	// CE 45 "ADD SP, HL"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 46 ".DB $CF,$46"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 47 ".DB $CF,$47"
	{0x00, 2, 6, 0,22, 0,20, 0},	// CE 48 "SUB X, BA"
	{0x00, 2, 6, 0,22, 0,21, 0},	// CE 49 "SUB X, HL"
	{0x00, 2, 6, 0,23, 0,20, 0},	// CE 4A "SUB Y, BA"
	{0x00, 2, 6, 0,23, 0,21, 0},	// CE 4B "SUB Y, HL"
	{0x00, 2, 6, 0,19, 0,20, 0},	// CE 4C "SUB SP, BA"
	{0x00, 2, 6, 0,19, 0,21, 0},	// CE 4D "SUB SP, HL"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 4E ".DB $CF,$4E"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 4F ".DB $CF,$4F"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 50 ".DB $CF,$50"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 51 ".DB $CF,$51"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 52 ".DB $CF,$52"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 53 ".DB $CF,$53"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 54 ".DB $CF,$54"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 55 ".DB $CF,$55"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 56 ".DB $CF,$56"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 57 ".DB $CF,$57"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 58 ".DB $CF,$58"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 59 ".DB $CF,$59"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 5A ".DB $CF,$5A"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 5B ".DB $CF,$5B"
	{0x00, 2,10, 0,19, 0,20, 0},	// CE 5C "CMP SP, BA"
	{0x00, 2,10, 0,19, 0,21, 0},	// CE 5D "CMP SP, HL"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 5E ".DB $CF,$5E"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 5F ".DB $CF,$5F"
	{0x00, 4, 5, 0,20, 0, 5, 2},	// CE 60 "ADC BA, %U"
	{0x00, 4, 5, 0,21, 0, 5, 2},	// CE 61 "ADC HL, %U"
	{0x00, 4, 7, 0,20, 0, 5, 2},	// CE 62 "SBC BA, %U"
	{0x00, 4, 7, 0,21, 0, 5, 2},	// CE 63 "SBC HL, %U"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 64 ".DB $CF,$64"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 65 ".DB $CF,$65"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 66 ".DB $CF,$66"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 67 ".DB $CF,$67"
	{0x00, 4, 4, 0,19, 0, 5, 2},	// CE 68 "ADD SP, %U"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 69 ".DB $CF,$69"
	{0x00, 4, 6, 0,19, 0, 5, 2},	// CE 6A "SUB SP, %U"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 6B ".DB $CF,$6B"
	{0x00, 4,10, 0,19, 0, 5, 2},	// CE 6C "CMP SP, %U"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 6D ".DB $CF,$6D"
	{0x00, 4, 2, 0,19, 0, 5, 2},	// CE 6E "MOV SP, %U"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE 6F ".DB $CF,$6F"
	{0x00, 3, 2, 0,20, 0,36, 2},	// CE 70 "MOV BA, [SP+%s]"
	{0x00, 3, 2, 0,21, 0,36, 2},	// CE 71 "MOV HL, [SP+%s]"
	{0x00, 3, 2, 0,22, 0,36, 2},	// CE 72 "MOV X, [SP+%s]"
	{0x00, 3, 2, 0,23, 0,36, 2},	// CE 73 "MOV Y, [SP+%s]"
	{0x00, 3, 2, 0,36, 2,20, 0},	// CE 74 "MOV [SP+%s], BA"
	{0x00, 3, 2, 0,36, 2,21, 0},	// CE 75 "MOV [SP+%s], HL"
	{0x00, 3, 2, 0,36, 2,22, 0},	// CE 76 "MOV [SP+%s], X"
	{0x00, 3, 2, 0,36, 2,23, 0},	// CE 77 "MOV [SP+%s], Y"
	{0x00, 4, 2, 0,19, 0,13, 2},	// CE 78 "MOV SP, [%U]"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 79 ".DB $CF,$79,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 7A ".DB $CF,$7A,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 7B ".DB $CF,$7B,%u,%u"
	{0x00, 4, 2, 0,13, 2,19, 0},	// CE 7C "MOV [%U], SP"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 7D ".DB $CF,$7D,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 7E ".DB $CF,$7E,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 7F ".DB $CF,$7F,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 80 ".DB $CF,$80,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 81 ".DB $CF,$81,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 82 ".DB $CF,$82,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 83 ".DB $CF,$83,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 84 ".DB $CF,$84,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 85 ".DB $CF,$85,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 86 ".DB $CF,$86,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 87 ".DB $CF,$87,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 88 ".DB $CF,$88,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 89 ".DB $CF,$89,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 8A ".DB $CF,$8A,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 8B ".DB $CF,$8B,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 8C ".DB $CF,$8C,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 8D ".DB $CF,$8D,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 8E ".DB $CF,$8E,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 8F ".DB $CF,$8F,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 90 ".DB $CF,$90,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 91 ".DB $CF,$91,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 92 ".DB $CF,$92,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 93 ".DB $CF,$93,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 94 ".DB $CF,$94,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 95 ".DB $CF,$95,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 96 ".DB $CF,$96,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 97 ".DB $CF,$97,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 98 ".DB $CF,$98,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 99 ".DB $CF,$99,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 9A ".DB $CF,$9A,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 9B ".DB $CF,$9B,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 9C ".DB $CF,$9C,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 9D ".DB $CF,$9D,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 9E ".DB $CF,$9E,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE 9F ".DB $CF,$9F,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A0 ".DB $CF,$A0,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A1 ".DB $CF,$A1,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A2 ".DB $CF,$A2,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A3 ".DB $CF,$A3,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A4 ".DB $CF,$A4,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A5 ".DB $CF,$A5,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A6 ".DB $CF,$A6,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A7 ".DB $CF,$A7,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A8 ".DB $CF,$A8,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE A9 ".DB $CF,$A9,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE AA ".DB $CF,$AA,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE AB ".DB $CF,$AB,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE AC ".DB $CF,$AC,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE AD ".DB $CF,$AD,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE AE ".DB $CF,$AE,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE AF ".DB $CF,$AF,%u,%u"
	{0x00, 2,16, 0, 8, 0, 0, 0},	// CE B0 "PUSH A"
	{0x00, 2,16, 0, 9, 0, 0, 0},	// CE B1 "PUSH B"
	{0x00, 2,16, 0,16, 0, 0, 0},	// CE B2 "PUSH L"
	{0x00, 2,16, 0,17, 0, 0, 0},	// CE B3 "PUSH H"
	{0x00, 2,17, 0, 8, 0, 0, 0},	// CE B4 "POP A"
	{0x00, 2,17, 0, 9, 0, 0, 0},	// CE B5 "POP B"
	{0x00, 2,17, 0,16, 0, 0, 0},	// CE B6 "POP L"
	{0x00, 2,17, 0,17, 0, 0, 0},	// CE B7 "POP H"
	{0x00, 2,52, 0, 0, 0, 0, 0},	// CE B8 "PUSHA"
	{0x00, 2,53, 0, 0, 0, 0, 0},	// CE B9 "PUSHAX"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE BA ".DB $CF,$BA,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE BB ".DB $CF,$BB,%u,%u"
	{0x00, 2,54, 0, 0, 0, 0, 0},	// CE BC "POPA"
	{0x00, 2,55, 0, 0, 0, 0, 0},	// CE BD "POPAX"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE BE ".DB $CF,$BE,%u,%u"
	{0x00, 4, 0, 0, 4, 0, 4, 0},	// CE BF ".DB $CF,$BF,%u,%u"
	{0x00, 2, 2, 0,20, 0,11, 0},	// CE C0 "MOV BA, [HL]"
	{0x00, 2, 2, 0,21, 0,11, 0},	// CE C1 "MOV HL, [HL]"
	{0x00, 2, 2, 0,22, 0,11, 0},	// CE C2 "MOV X, [HL]"
	{0x00, 2, 2, 0,23, 0,11, 0},	// CE C3 "MOV Y, [HL]"
	{0x00, 2, 2, 0,11, 0,20, 0},	// CE C4 "MOV [HL], BA"
	{0x00, 2, 2, 0,11, 0,21, 0},	// CE C5 "MOV [HL], HL"
	{0x00, 2, 2, 0,11, 0,22, 0},	// CE C6 "MOV [HL], X"
	{0x00, 2, 2, 0,11, 0,23, 0},	// CE C7 "MOV [HL], Y"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE C8 ".DB $CF,$C8"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE C9 ".DB $CF,$C9"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE CA ".DB $CF,$CA"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE CB ".DB $CF,$CB"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE CC ".DB $CF,$CC"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE CD ".DB $CF,$CD"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE CE ".DB $CF,$CE"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE CF ".DB $CF,$CF"
	{0x00, 2, 2, 0,20, 0,14, 0},	// CE D0 "MOV BA, [X]"
	{0x00, 2, 2, 0,21, 0,14, 0},	// CE D1 "MOV HL, [X]"
	{0x00, 2, 2, 0,22, 0,14, 0},	// CE D2 "MOV X, [X]"
	{0x00, 2, 2, 0,23, 0,14, 0},	// CE D3 "MOV Y, [X]"
	{0x00, 2, 2, 0,14, 0,20, 0},	// CE D4 "MOV [X], BA"
	{0x00, 2, 2, 0,14, 0,21, 0},	// CE D5 "MOV [X], HL"
	{0x00, 2, 2, 0,14, 0,22, 0},	// CE D6 "MOV [X], X"
	{0x00, 2, 2, 0,14, 0,23, 0},	// CE D7 "MOV [X], Y"
	{0x00, 2, 2, 0,20, 0,15, 0},	// CE D8 "MOV BA, [Y]"
	{0x00, 2, 2, 0,21, 0,15, 0},	// CE D9 "MOV HL, [Y]"
	{0x00, 2, 2, 0,22, 0,15, 0},	// CE DA "MOV X, [Y]"
	{0x00, 2, 2, 0,23, 0,15, 0},	// CE DB "MOV Y, [Y]"
	{0x00, 2, 2, 0,15, 0,20, 0},	// CE DC "MOV [Y], BA"
	{0x00, 2, 2, 0,15, 0,21, 0},	// CE DD "MOV [Y], HL"
	{0x00, 2, 2, 0,15, 0,22, 0},	// CE DE "MOV [Y], X"
	{0x00, 2, 2, 0,15, 0,23, 0},	// CE DF "MOV [Y], Y"
	{0x00, 2, 2, 0,20, 0,20, 0},	// CE E0 "MOV BA, BA"
	{0x00, 2, 2, 0,20, 0,21, 0},	// CE E1 "MOV BA, HL"
	{0x00, 2, 2, 0,20, 0,22, 0},	// CE E2 "MOV BA, X"
	{0x00, 2, 2, 0,20, 0,23, 0},	// CE E3 "MOV BA, Y"
	{0x00, 2, 2, 0,21, 0,20, 0},	// CE E4 "MOV HL, BA"
	{0x00, 2, 2, 0,21, 0,21, 0},	// CE E5 "MOV HL, HL"
	{0x00, 2, 2, 0,21, 0,22, 0},	// CE E6 "MOV HL, X"
	{0x00, 2, 2, 0,21, 0,23, 0},	// CE E7 "MOV HL, Y"
	{0x00, 2, 2, 0,22, 0,20, 0},	// CE E8 "MOV X, BA"
	{0x00, 2, 2, 0,22, 0,21, 0},	// CE E9 "MOV X, HL"
	{0x00, 2, 2, 0,22, 0,22, 0},	// CE EA "MOV X, X"
	{0x00, 2, 2, 0,20, 0,23, 0},	// CE EB "MOV X, Y"
	{0x00, 2, 2, 0,23, 0,20, 0},	// CE EC "MOV Y, BA"
	{0x00, 2, 2, 0,23, 0,21, 0},	// CE ED "MOV Y, HL"
	{0x00, 2, 2, 0,23, 0,22, 0},	// CE EE "MOV Y, X"
	{0x00, 2, 2, 0,23, 0,23, 0},	// CE EF "MOV Y, Y"
	{0x00, 2, 2, 0,19, 0,20, 0},	// CE F0 "MOV SP, BA"
	{0x00, 2, 2, 0,19, 0,21, 0},	// CE F1 "MOV SP, HL"
	{0x00, 2, 2, 0,19, 0,22, 0},	// CE F2 "MOV SP, X"
	{0x00, 2, 2, 0,19, 0,23, 0},	// CE F3 "MOV SP, Y"
	{0x00, 2, 2, 0,21, 0,19, 0},	// CE F4 "MOV HL, SP"
	{0x00, 2, 2, 0,21, 0,37, 0},	// CE F5 "MOV HL, PC"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE F6 ".DB $CF,$F6"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE F7 ".DB $CF,$F7"
	{0x00, 2, 2, 0,20, 0,19, 0},	// CE F8 "MOV BA, SP"
	{0x00, 2, 2, 0,20, 0,37, 0},	// CE F9 "MOV BA, PC"
	{0x00, 2, 2, 0,22, 0,19, 0},	// CE FA "MOV X, SP"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE FB ".DB $CF,$FB"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE FC ".DB $CF,$FC"
	{0x00, 2, 0, 0, 4, 0, 4, 0},	// CE FD ".DB $CF,$FD"
	{0x00, 2, 2, 0,23, 0,19, 0},	// CE FE "MOV Y, SP"
	{0x00, 2, 0, 0, 4, 0, 4, 0}	// CE FF ".DB $CF,$FF"
};
